% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{metrics.}
\alias{metrics.}
\title{Calculate metrics for model predictive performance evaluation}
\usage{
metrics.(pred.x, obs.y)
}
\arguments{
\item{pred.x}{Numeric vector of model-predicted values.}

\item{obs.y}{Numeric vector of corresponding observed values.}
}
\value{
A numeric vector with named elements:
\itemize{
\item APE: absolute prediction error
\item MAE: mean absolute error
\item MAPE: mean absolute percentage error
\item RMSE: root mean squared error
\item rRMSE1: relative RMSE (type 1)
\item rRMSE2: relative RMSE (type 2)
}
}
\description{
Computes common error metrics that quantify the predictive performance
of pharmacometric models by comparing predicted (pred.x) and observed (obs.y)
concentration values.
}
\details{
The function stops with an error if pred.x and obs.y have unequal lengths.
The following metrics are calculated:

\deqn{APE = \sum |pred.x - obs.y|}
Absolute prediction error (APE) is the sum of absolute differences.

\deqn{MAE = \frac{1}{n} \sum |pred.x - obs.y|}
Mean absolute error (MAE) expresses the average absolute deviation.

\deqn{MAPE = \frac{100}{n} \sum \left| \frac{pred.x - obs.y}{obs.y} \right|}
Mean absolute percentage error (MAPE) normalizes the error by observed values.

\deqn{RMSE = \sqrt{\frac{1}{n} \sum (pred.x - obs.y)^2}}
Root mean squared error (RMSE) penalizes larger deviations.

\deqn{rRMSE1 = \frac{RMSE}{\bar{obs.y}} \times 100}
Relative RMSE type 1 is the RMSE normalized by the mean observed value.

\deqn{rRMSE2 = 100 \times \sqrt{\frac{1}{n} \sum \left(
\frac{pred.x - obs.y}{(pred.x + obs.y)/2} \right)^2}}
Relative RMSE type 2 is symmetric and normalizes by the mean of each
predicted–observed pair.
}
\examples{

obs.y  <- rnorm(100, mean = 100, sd = 10)
pred.x <- obs.y + rnorm(100, mean = 0, sd = 5)
metrics.(pred.x = pred.x, obs.y = obs.y)

}
