#' pdSpecEst: An Analysis Toolbox for Hermitian Positive Definite Matrices
#'
#' The \code{pdSpecEst} (\strong{p}ositive \strong{d}efinite \strong{Spec}tral \strong{Est}imation)
#' package provides data analysis tools for samples of symmetric or Hermitian positive definite matrices,
#' such as collections of positive definite covariance matrices or spectral density matrices.
#'
#' The tools in this package can be used to perform:
#' \itemize{
#'    \item \emph{Intrinsic wavelet transforms} for curves (1D) and surfaces (2D) of Hermitian positive
#'    definite matrices, with applications to for instance: dimension reduction, denoising and clustering for curves or
#'    surfaces of Hermitian positive definite matrices, such as (time-varying) Fourier spectral density matrices.
#'    These implementations are based in part on the paper \insertCite{CvS17}{pdSpecEst} and Chapters 3
#'    and 5 of \insertCite{C18}{pdSpecEst}.
#'    \item Exploratory data analysis and inference for samples of Hermitian positive definite matrices by
#'    means of \emph{intrinsic data depth} and \emph{depth rank-based hypothesis tests}. These implementations are based
#'    on the paper \insertCite{COvS17}{pdSpecEst} and Chapter 4 of \insertCite{C18}{pdSpecEst}.
#'  }
#' For more details and examples on how to use the package see the accompanying vignettes in the vignettes folder.
#'
#' Author and maintainer: \strong{Joris Chau} (\email{joris.chau@@openanalytics.eu}).
#'
#' @references
#' \insertAllCited{}
#'
#' @useDynLib pdSpecEst, .registration = TRUE
#' @importFrom Rcpp evalCpp
#' @importFrom Rdpack reprompt
#' @import utils
#' @import stats
#' @name pdSpecEst-package
#' @aliases pdSpecEst
"_PACKAGE"
