% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Mid}
\alias{Mid}
\title{Geodesic midpoint between HPD matrices}
\usage{
Mid(A, B)
}
\arguments{
\item{A, B}{Hermitian positive definite matrices (of equal dimension).}
}
\description{
\code{Mid} calculates the geodesic midpoint between two HPD matrices under the
affine-invariant Riemannian metric as in \insertCite{B09}{pdSpecEst}[Chapter 6].
}
\examples{
 ## Generate two random HPD matrices
 a <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 A <- t(Conj(a)) \%*\% a
 b <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 B <- t(Conj(b)) \%*\% b
 ## Compute midpoint
 Mid(A, B)
 ## Midpoint coincides with two-point intrinsic Karcher mean
 all.equal(pdMean(array(c(A, B), dim = c(3, 3, 2))), Mid(A, B))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{pdMean}}
}
