% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meandist.R
\name{pdMedian}
\alias{pdMedian}
\title{Weighted intrinsic median of HPD matrices}
\usage{
pdMedian(M, w, metric = "Riemannian", maxit = 1000, reltol)
}
\arguments{
\item{M}{a \eqn{(d,d,S)}-dimensional array corresponding to a sample of \eqn{(d,d)}-dimensional HPD matrices of
size \eqn{S}.}

\item{w}{an \eqn{S}-dimensional nonnegative weight vector, such that \code{sum(w) = 1}.}

\item{metric}{the distance measure, one of \code{'Riemannian'}, \code{'logEuclidean'},
\code{'Cholesky'}, \code{'Euclidean'} or \code{'rootEuclidean'}. Defaults to \code{'Riemannian'}.}

\item{maxit}{maximum number of iterations in gradient descent algorithm. Defaults to \code{1000}}

\item{reltol}{optional tolerance parameter in gradient descent algorithm. Defaults to \code{1E-10}.}
}
\description{
\code{pdMedian} calculates a weighted intrinsic median of a sample of \eqn{(d,d)}-dimensional
HPD matrices based on a Weiszfeld algorithm intrinsic to the chosen metric.In the case of the
affine-invariant Riemannian metric as detailed in e.g., \insertCite{B09}{pdSpecEst}[Chapter 6] or
\insertCite{PFA05}{pdSpecEst}, the intrinsic Weiszfeld algorithm in \insertCite{F09}{pdSpecEst} is used.
By default, the unweighted intrinsic median is computed.
}
\note{
The function does not check for positive definiteness of the input matrices, and (depending on the
specified metric) may fail if matrices are close to being singular.
}
\examples{
## Generate random sample of HPD matrices
m <- function(){
 X <- matrix(complex(real=rnorm(9), imaginary=rnorm(9)), nrow=3)
 t(Conj(X)) \%*\% X
}
M <- replicate(100, m())
## Generate random weight vector
z <- rnorm(100)
w <- abs(z)/sum(abs(z))
## Compute weighted intrinsic (Riemannian) median
pdMedian(M, w)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{pdMean}}
}
