% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-colors.r
\docType{data}
\name{lamp_colors}
\alias{lamp_colors}
\alias{uv_lamps}
\alias{purple_lamps}
\alias{blue_lamps}
\alias{green_lamps}
\alias{yellow_lamps}
\alias{orange_lamps}
\alias{red_lamps}
\alias{ir_lamps}
\alias{amber_lamps}
\alias{white_lamps}
\title{Spectral data for Lamps of different colours}
\format{
A vector of character strings.

An object of class \code{character} of length 11.

An object of class \code{character} of length 0.

An object of class \code{character} of length 0.

An object of class \code{character} of length 0.

An object of class \code{character} of length 0.

An object of class \code{character} of length 0.

An object of class \code{character} of length 4.

An object of class \code{character} of length 2.

An object of class \code{character} of length 0.

An object of class \code{character} of length 50.
}
\usage{
lamp_colors

uv_lamps

purple_lamps

blue_lamps

green_lamps

yellow_lamps

orange_lamps

red_lamps

ir_lamps

amber_lamps

white_lamps
}
\description{
Names of members of the \code{\link{lamps.mspct}} collection of spectra
grouped by colour or wavelength band.
}
\details{
contain the names of the members of \code{lamps.mspct} with peaks of
  emission within the wavelength range corresponding to the light colours as
  defined by ISO standards. Vector \code{amber_lamps} is the union of
  \code{"yellow_lamps"} and \code{"orange_lamps"}. Vector \code{white_lamps}
  contains the names of spectra for lamps with broad or multiple peaks of
  emission in the visible range. Vectors \code{"uv_lamps"} and
  \code{"ir_lamps"} contain the names for lamps with peak emission at
  wavelengths < 400 nm and wavelengths > 700 nm, respectively.  One 
  additional vector, \code{lamp_colors} contains the names of
  the colors as used in the vectors.

  These vectors can be used to extract subsets of spectra from
  \code{lamps.mspct}.
}
\examples{
lamp_colors

uv_lamps
blue_lamps
red_lamps
white_lamps

# select data for lamps  emitting in the ultraviolet region
lamps.mspct[uv_lamps]

}
\seealso{
\code{\link{lamps.mspct}}

Other indexing vectors of names: 
\code{\link{lamp_brands}},
\code{\link{lamp_types}},
\code{\link{lamp_uses}}
}
\concept{indexing vectors of names}
\concept{lamps by color}
\keyword{datasets}
