% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{emeasure}
\alias{emeasure}
\alias{emeasure,ANY-method}
\alias{emeasure,missing-method}
\alias{emeasure,pomp-method}
\title{emeasure workhorse}
\usage{
\S4method{emeasure}{pomp}(
  object,
  ...,
  x = states(object),
  times = time(object),
  params = coef(object)
)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{...}{additional arguments are ignored.}

\item{x}{an array containing states of the unobserved process.
The dimensions of \code{x} are \code{nvars} x \code{nrep} x \code{ntimes},
where \code{nvars} is the number of state variables,
\code{nrep} is the number of replicates,
and \code{ntimes} is the length of \code{times}.
One can also pass \code{x} as a named numeric vector, which is equivalent to the \code{nrep=1}, \code{ntimes=1} case.}

\item{times}{a numeric vector (length \code{ntimes}) containing times.
These must be in non-decreasing order.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}
}
\value{
\code{emeasure} returns a rank-3 array of dimensions
\code{nobs} x \code{nrep} x \code{ntimes},
where \code{nobs} is the number of observed variables.
}
\description{
Return the expected value of the observed variables, given values of the latent states and the parameters.
}
\seealso{
Specification of the measurement-model expectation: \link{emeasure_spec}

More on \pkg{pomp} workhorse functions:
\code{\link{dinit}()},
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{vmeasure}()},
\code{\link{workhorses}}
}
\concept{pomp workhorses}
