% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_example_data.R
\name{glm_data}
\alias{glm_data}
\title{Generate data simulated from a GLM}
\usage{
glm_data(formula, ..., family = gaussian(), family_args = NULL)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class):
a symbolic description of the model to be fitted. The details of model specification are
given under ‘Details’ in the \link{glm} documentation.}

\item{...}{a \code{data.frame} with columns corresponding to variables used
in \code{formula}, a named \code{list} of those variables, or individually provided
named arguments of variables}

\item{family}{the \code{family} of the response. this can be a \code{character}
string naming a family function, a family \code{function} or the result of
a \code{call} to a family function}

\item{family_args}{a named \code{list} with values of arguments passed to
family relevant \verb{r<family_name>} function for simulating the data}
}
\value{
a \code{data.frame}
}
\description{
Provide a formula, variables and a family to generate a linear predictor
using the formula and provided variables before using the inverse link of
the family to generate the GLM modelled mean, mu, which is then used to
simulate the response with this mean from the generating function according
to the chosen family.
}
\examples{
# Generate a gaussian response from a single covariate
glm_data(Y ~ 1+2*x1,
                x1 = rnorm(10))

# Generate a gaussian response from a single covariate with non-linear
# effects. Specify that the response should have standard deviation sqrt(3)
glm_data(Y ~ 1+2*log(x1),
                x1 = runif(10, min = 1, max = 10),
                family_args = list(sd = sqrt(3)))

# Generate a negative binomial response
glm_data(Y ~ 1+2*x1-x2,
                x1 = rnorm(10),
                x2 = rgamma(10, shape = 2),
                family = MASS::negative.binomial(2))

# Provide variables as a list/data.frame and pass a link to the negative.binomial
# function
glm_data(resp ~ 1+2*x1-x2,
                data.frame(
                  x1 = rnorm(10),
                  x2 = rgamma(10, shape = 2)
                ),
                family = MASS::negative.binomial(2),
                family_args = list(link = "identity"))

}
