% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currencies.R
\name{make_dates}
\alias{make_dates}
\title{Creates date ranges so as to batch up large API calls into many smaller ones}
\usage{
make_dates(start_date, end_date, n_days)
}
\arguments{
\item{start_date}{A start date (of the form "2010-01-01")}

\item{end_date}{An end date}

\item{n_days}{The maximum number of days in each period}
}
\value{
A data.frame containing start and end dates for periods of length no longer than n_days
}
\description{
Creates date ranges so as to batch up large API calls into many smaller ones
}
\examples{

# Simple test
start_date = "2010-01-01"
end_date = "2020-06-30"
n_days = 365
priceR:::make_dates(start_date, end_date, n_days)

# With lots of periods
start_date = "2010-01-01"
end_date = "2020-06-30"
n_days = 20
priceR:::make_dates(start_date, end_date, n_days)

# Less than one period
start_date = "2020-01-01"
end_date = "2020-06-30"
n_days = 365
priceR:::make_dates(start_date, end_date, n_days)

# 366 days (note 2020 was a leap year)
start_date = "2019-07-30"
end_date = "2020-07-29"
n_days = 365
priceR:::make_dates(start_date, end_date, n_days)

# 365 days
start_date = "2019-07-30"
end_date = "2020-07-28"
n_days = 365
priceR:::make_dates(start_date, end_date, n_days)

# 1095 days (3 years)
start_date = "2019-07-30"
end_date = "2022-07-28"
n_days = 365
priceR:::make_dates(start_date, end_date, n_days)

}
