% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_object_S3_methods.R
\name{logLik.pvEBayes}
\alias{logLik.pvEBayes}
\title{Extract log marginal likelihood for a pvEBayes object}
\usage{
\method{logLik}{pvEBayes}(object, ...)
}
\arguments{
\item{object}{a \code{pvEBayes} object, which is the output of the function
\link{pvEBayes} or \link{pvEBayes_tune}.}

\item{...}{other input parameters. Currently unused.}
}
\value{
returns log marginal likelihood of a pvEBayes object.
}
\description{
This function defines the S3 \code{logLik} method for objects of class
\code{pvEBayes}. It extracts the log marginal likelihood from a fitted
model.
}
\examples{

fit <- pvEBayes(
  contin_table = statin2025_44, model = "general-gamma",
  alpha = 0.3, n_posterior_draws = NULL
)

logLik(fit)

}
