% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarioId.R
\name{scenarioId}
\alias{scenarioId}
\alias{scenarioId,character-method}
\alias{scenarioId,Scenario-method}
\title{Retrieves scenarioId of Scenario}
\usage{
scenarioId(scenario)

\S4method{scenarioId}{character}(scenario)

\S4method{scenarioId}{Scenario}(scenario)
}
\arguments{
\item{scenario}{\code{\link{Scenario-class}} object}
}
\value{
Integer id of the input Scenario.
}
\description{
Retrieves the scenarioId of a \code{\link{Scenario-class}}.
}
\examples{
\dontrun{
# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib")

# Set the SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession) 
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Get Scenario ID of Scenario
scenarioId(myScenario)
}

}
