% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACF.R
\name{compare_acf}
\alias{compare_acf}
\title{Comparison of Classical and Robust Correlation Analysis Functions}
\usage{
compare_acf(
  x,
  lag.max = NULL,
  demean = TRUE,
  show.ci = TRUE,
  alpha = 0.05,
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{vector} or \code{"ts"} object (of length \eqn{N > 1}).}

\item{lag.max}{A \code{integer} indicating the maximum lag up to which to compute the ACF and PACF functions.}

\item{demean}{A \code{bool} indicating whether the data should be detrended (\code{TRUE}) or not (\code{FALSE}). Defaults to \code{TRUE}.}

\item{show.ci}{A \code{bool} indicating whether to compute and show the confidence region. Defaults to \code{TRUE}.}

\item{alpha}{A \code{double} indicating the level of significance for the confidence interval. By default \code{alpha = 0.05} which gives a 1 - \code{alpha} = 0.95 confidence interval.}

\item{plot}{A \code{bool} indicating whether a plot of the computed quantities should be produced. Defaults to \code{TRUE}.}

\item{...}{Additional parameters.}
}
\description{
Compare classical and robust ACF
of univariate time series.
}
\examples{
# Estimate both the ACF and PACF functions
compare_acf(datasets::AirPassengers)
}
\author{
Yunxiang Zhang
}
