% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplitude.R
\name{transplantEnv}
\alias{transplantEnv}
\title{Transplant envelope}
\usage{
transplantEnv(
  donor,
  samplingRateD = NULL,
  recipient,
  samplingRateR = samplingRateD,
  windowLength = 50,
  method = c("hil", "rms", "peak")[3],
  killDC = FALSE,
  dynamicRange = 80,
  plot = FALSE
)
}
\arguments{
\item{donor}{the sound that "donates" the amplitude envelope}

\item{samplingRateD, samplingRateR}{sampling rate of the donor and recipient,
respectively (only needed for vectors, not files)}

\item{recipient}{the sound that needs to have its amplitude envelope adjusted}

\item{windowLength}{the length of smoothing window, ms}

\item{method}{hil = Hilbert envelope, rms = root mean square amplitude, peak
= peak amplitude per window}

\item{killDC}{if TRUE, dynamically removes DC offset or similar deviations of
average waveform from zero (see examples)}

\item{dynamicRange}{parts of sound quieter than \code{-dynamicRange} dB will
not be amplified}

\item{plot}{if TRUE, plots the original sound, the smoothed envelope, and
the compressed sound}
}
\value{
Returns the recipient sound with the donor's amplitude envelope - a
  numeric vector with the same sampling rate as the recipient
}
\description{
Extracts a smoothed amplitude envelope of the \code{donor} sound and applies
it to the \code{recipient} sound. Both sounds are provided as numeric
vectors; they can differ in length and sampling rate. Note that the result
depends on the amount of smoothing (controlled by \code{windowLength}) and
the chosen method of calculating the envelope. Very similar to
\code{\link[seewave]{setenv}}, but with a different smoothing algorithm and
with a choice of several types of envelope: hil, rms, or peak.
}
\examples{
donor = rnorm(500) * seq(1, 0, length.out = 500)
recipient = soundgen(sylLen = 600, addSilence = 50)
transplantEnv(donor, samplingRateD = 200,
               recipient, samplingRateR = 16000,
               windowLength = 50, method = 'hil', plot = TRUE)
transplantEnv(donor, samplingRateD = 200,
               recipient, samplingRateR = 16000,
               windowLength = 10, method = 'peak', plot = TRUE)
}
\seealso{
\code{\link{flatEnv}} \code{\link[seewave]{setenv}}
}
