% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sps_iterator.R
\name{sps_iterator}
\alias{sps_iterator}
\title{Iteratively draw a sequential Poisson sample}
\usage{
sps_iterator(x, n = 0L, prn = NULL, alpha = 0.001, cutoff = Inf)
}
\arguments{
\item{x}{A positive and finite numeric vector of sizes for units in the
population (e.g., revenue for drawing a sample of businesses).}

\item{n}{A positive integer giving the initial sample size for the iterator.}

\item{prn}{A numeric vector of permanent random numbers for units in the
population, distributed uniform between 0 and 1. The default does not use
permanent random numbers, instead generating a random vector when the
function is called.}

\item{alpha}{A number between 0 and 1. Units with
inclusion probabilities greater than or equal to 1 - \code{alpha} are set to 1.
The default is slightly larger than 0.}

\item{cutoff}{A numeric cutoff. Units with \code{x >= cutoff} get
an inclusion probability of 1. The default does not apply a cutoff.}
}
\value{
A function that returns the next unit in the sample. It take a single
argument giving the sentinel value to indicate that there are no units
left to sample (default \code{NULL}).
}
\description{
Create a function that draws new units, one at a time, according to the
sequential Poisson method without replacing previously sampled units.
}
\examples{
prn <- runif(5)
s <- sps_iterator(1:5, prn = prn)
s()
s()
s()

# Same as drawing the sample with 3 units.
sps(1:5, 3, prn = prn)
}
