% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wls.R
\name{wls}
\alias{wls}
\title{Get Weighted Least Squares of Your OLS Model}
\usage{
wls(mod)
}
\arguments{
\item{mod}{a fitted OLS model}
}
\value{
\code{wls()} returns a new model object that is a weighted least squares re-estimation
of the OLS model supplied to it.
}
\description{
\code{wls()} takes an OLS model and re-estimates it using a weighted least squares
approach. Weighted least squares is often a "textbook" approach to dealing with the presence of
heteroskedastic standard errors, for which the weighted least squares estimates are compared
to the OLS estimates of uncertainty to check for consistency or potential inferential implications.
}
\details{
The function \emph{should} be robust to potential model specification oddities (e.g. polynomials
and fixed effects). It also should perform nicely in the presence of missing data, if and only
if \code{na.action = na.exclude} is supplied first to the offending OLS model supplied to the function
for a weighted least squares re-estimation.
}
\examples{

M1 <- lm(mpg ~ ., data=mtcars)
M2 <- wls(M1)

summary(M2)
}
\author{
Steven V. Miller
}
