% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{createCppJsonFile}
\alias{createCppJsonFile}
\title{Create a C++ Json object from a Json file}
\usage{
createCppJsonFile(json_filename)
}
\arguments{
\item{json_filename}{Name of file to read. Must end in \code{.json}.}
}
\value{
\code{CppJson} object
}
\description{
Create a C++ Json object from a Json file
}
\examples{
example_vec <- runif(10)
example_json <- createCppJson()
example_json$add_vector("myvec", example_vec)
tmpjson <- tempfile(fileext = ".json")
example_json$save_file(file.path(tmpjson))
example_json_roundtrip <- createCppJsonFile(file.path(tmpjson))
unlink(tmpjson)
}
