% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tepr.R
\name{teprmulti}
\alias{teprmulti}
\title{Perform tepr differential nascent rna-seq analysis for multiple conditions}
\usage{
teprmulti(expdf, alldf, expthres, nbcpu = 1, rounding = 10,
 dontcompare = NULL, replaceval = NA, pval = 0.1, significant = FALSE,
 windsizethres = 50, countnathres = 20, pvaltheorythres = 0.1,
 meancondonethres = 0.5, meancondtwothres = 0.5,
 auccondonethreshigher = -10, auccondonethreslower = 15, auccondtwothres = 15,
 attenuatedpvalksthres = 2, outgrouppvalksthres = 0.2,
 saveobjectpath = NA, reload = FALSE, showtime = FALSE, showmemory = FALSE,
 verbose = TRUE)
}
\arguments{
\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{alldf}{A data frame containing all transcript-related information,
including biotype, chromosome, coordinates, transcript, gene,
strand, window, ID and scores retrieved from the bedgraph files.}

\item{expthres}{A numeric value specifying the expression threshold.
Transcripts with average expression values below this threshold
will be filtered out from the returned transcript vector.}

\item{nbcpu}{An integer specifying the number of CPU cores to use for
parallel computation on transcripts. Defaults to \code{1}.}

\item{rounding}{An integer specifying the rounding factor for computing ECDF.
Default is \code{10}.}

\item{dontcompare}{An optional vector specifying conditions to exclude
from the comparison. It should use condition names from expdf and
follow the pattern \code{cond1_vs_cond2}. Defaults to \code{NULL}.}

\item{replaceval}{A value to replace non-significant attenuation values.
Defaults to \code{NA}.}

\item{pval}{A numeric value specifying the p-value threshold for significance
of the KS test. Defaults to \code{0.1}.}

\item{significant}{A logical indicating whether to filter out non-significant
attenuation values. Defaults to \code{FALSE}.}

\item{windsizethres}{A numeric threshold for the minimum window size.
Default is 50.}

\item{countnathres}{A numeric threshold for the maximum number of missing
data points for an experiment (NA values). Default is 20.}

\item{pvaltheorythres}{A numeric threshold for the minimum p-value used to
define the universe of genes. Default is 0.1.}

\item{meancondonethres}{A numeric threshold for the minimum mean transcription
value in the first condition of each comparison. Default is 0.5.}

\item{meancondtwothres}{A numeric threshold for the minimum mean transcription
value in the second condition of each comparison. Default is 0.5.}

\item{auccondonethreshigher}{A numeric threshold for the lower bound of the
first condition AUC value in the outgroup classification.
Default is -10.}

\item{auccondonethreslower}{A numeric threshold for the upper bound of the
first condition AUC value in the outgroup classification.
Default is 15.}

\item{auccondtwothres}{A numeric threshold for the minimum second condition
AUC value used to classify attenuated genes. Default is 15.}

\item{attenuatedpvalksthres}{A numeric threshold for the negative log10 of
the p-value (from KS test) for defining attenuated genes.
Default is 2.}

\item{outgrouppvalksthres}{A numeric threshold for the maximum KS p-value
used to define the outgroup. Default is 0.2.}

\item{saveobjectpath}{A character string specifying the path to save
the object of the results for each comparison. The file names are
defined with the 'condition' column of expdf. Defaults to \code{NA}.}

\item{reload}{Logical. If `TRUE`, reloads existing saved objects to avoid
recomputation. Default is `FALSE`. If the function failed during object
saving, make sure to delete the corresponding object.}

\item{showtime}{A logical value indicating if the duration of the function
processing should be indicated before ending. Defaults to
\code{FALSE}.}

\item{showmemory}{A logical value indicating if memory usage should be
printed during the execution. Defaults to \code{FALSE}.}

\item{verbose}{A logical flag indicating whether to print progress messages.
Defaults to \code{TRUE}.}
}
\value{
A list of lists. Each inner list corresponds to a pairwise comparison
and contains two data frames:
  - `resmeandiff_<comparison>`: Results from the `meandifference` function
    for the specific comparison.
  - `resunigroupatt_<comparison>`: Results from the `universegroup` function
    for the specific comparison.
}
\description{
This function performs tepr differential nascent RNA-seq analysis for
multiple conditions. It iterates over all pairwise comparisons of
conditions within the experiment table and calls the `tepr` function for
each pair.
}
\examples{
## Supposing the data have more than one condition
\dontrun{
  exptabpath <- "exp.csv"
  alldfpath <- "result-preprocessing.tsv"
  expdf <- read.csv(exptabpath)
  alldf <- read.delim(alldfpath, header = FALSE)
  expthres <- 0.1
  reslist <- teprmulti(expdf, alldf, expthres)}

}
\seealso{
[tepr]
}
