% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-coco.R
\name{coco_caption_dataset}
\alias{coco_caption_dataset}
\title{COCO Caption Dataset}
\usage{
coco_caption_dataset(
  root = tempdir(),
  train = TRUE,
  year = c("2014"),
  download = FALSE,
  transform = NULL,
  target_transform = NULL
)
}
\arguments{
\item{root}{Root directory where the dataset is stored or will be downloaded to.}

\item{train}{Logical. If TRUE, loads the training split; otherwise, loads the validation split.}

\item{year}{Character. Dataset version year. One of \code{"2014"}.}

\item{download}{Logical. If TRUE, downloads the dataset if it's not already present in the \code{root} directory.}

\item{transform}{Optional transform function applied to the image.}

\item{target_transform}{Optional transform function applied to the target (labels, boxes, etc.).}
}
\value{
An object of class \code{coco_caption_dataset}. Each item is a list:
\itemize{
\item \code{x}: an \verb{(H, W, C)} numeric array containing the RGB image.
\item \code{y}: a character string with the image caption.
}
}
\description{
Loads the MS COCO dataset for image captioning.
}
\examples{
\dontrun{
ds <- coco_caption_dataset(
  train = FALSE,
  download = TRUE
)
example <- ds[1]

# Access image and caption
x <- example$x
y <- example$y

# Prepare image for plotting
image_array <- as.numeric(x)
dim(image_array) <- dim(x)

plot(as.raster(image_array))
title(main = y, col.main = "black")
}
}
\seealso{
Other caption_dataset: 
\code{\link{flickr_caption_dataset}}
}
\concept{caption_dataset}
