% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_coverage.R
\name{plot_coverage}
\alias{plot_coverage}
\title{Plot Vaccine Coverage}
\usage{
plot_coverage(vaccineff_data, date_interval = NULL, cumulative = FALSE)
}
\arguments{
\item{vaccineff_data}{Object of the class \code{vaccineff_data} with
vaccineff data.}

\item{date_interval}{If NULL, the function calculates the coverage interval
based on the min() and max() of the \code{vacc_date_col}. It is also possible to
pass a custom date interval to truncate or expand the date interval (see
example).}

\item{cumulative}{If \code{TRUE}, returns the cumulative number of doses over the
time window.}
}
\value{
2-axis ggplot2 plot of vaccine coverage and daily doses.
}
\description{
This function returns a plot of the vaccine coverage or the
cumulative coverage (if cumulative = TRUE). The return is a 2-axis \code{ggplot2}
element with the number of vaccines per date on the left axis and the
coverage per date on the right axis. When a matching routine is performed,
the left axis also accounts for the doses of the matched cohort.
}
\keyword{internal}
