% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_fill_depressions}
\alias{wbt_fill_depressions}
\title{Fill depressions}
\usage{
wbt_fill_depressions(
  dem,
  output,
  fix_flats = TRUE,
  flat_increment = NULL,
  max_depth = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{fix_flats}{Optional flag indicating whether flat areas should have a small gradient applied.}

\item{flat_increment}{Optional elevation increment applied to flat areas.}

\item{max_depth}{Optional maximum depression depth to fill.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Fills all of the depressions in a DEM. Depression breaching should be preferred in most cases.
}
\keyword{HydrologicalAnalysis}
