% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{roc_by_mod}
\alias{roc_by_mod}
\title{ROC curve across models}
\usage{
roc_by_mod(
  xpdb_s,
  ...,
  .lineage = FALSE,
  mapping = NULL,
  cutpoint = 1,
  type = "ca",
  title = "ROC curves across models | @dvcol~@probcol",
  subtitle = "Based on @nind individuals, Ofvs: @ofv",
  caption = "@dir",
  tag = NULL,
  axis.text = "@run",
  facets,
  .problem,
  quiet,
  roc_args = NULL
)
}
\arguments{
\item{xpdb_s}{<\code{xpose_set}> object}

\item{...}{Any additional aesthetics.}

\item{.lineage}{<\code{logical}> where if \code{TRUE}, \code{...} is processed}

\item{mapping}{\code{ggplot2} style mapping}

\item{cutpoint}{<\code{numeric}> Of defined probabilities, which one to
use in plots.}

\item{type}{See Details.}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{axis.text}{What to label the model. This is parsed on a per-model
basis.}

\item{facets}{Additional facets}

\item{.problem}{Problem number}

\item{quiet}{Silence extra debugging output}

\item{roc_args}{Additional arguments to pass to \code{\link[=xplot_rocplot]{xplot_rocplot()}}}
}
\description{
Faceted display of ROC curves across models in a set.
}
\details{
For type-based customization of plots:
\itemize{
\item \code{c} ROC curve (using \code{geom_path})
\item \code{k} Key points on ROC curve (where on curve the
threshold is \code{thres_fixed}) (using \code{geom_point})
\item \code{p} ROC space points (using \code{geom_point})
\item \code{t} ROC space text (using \code{geom_text})
\item \code{a} AUC in bottom right (using \code{geom_label})
}
}
\examples{

pkpd_m3 <- pkpd_m3 \%>\%
  # Need to ensure var types are set
  set_var_types(catdv=BLQ,dvprobs=LIKE) \%>\%
  # Set probs
  set_dv_probs(1, 1~LIKE, .dv_var = BLQ) \%>\%
  # Optional, but useful to set levels
  set_var_levels(1, BLQ = lvl_bin())

m3_set <- xpose_set(
  run1=set_prop(pkpd_m3,run="run1"),
  run2=set_prop(pkpd_m3,run="run2"),
  run3=set_prop(pkpd_m3,run="run3")
)

roc_by_mod(m3_set, type = "ck", quiet = TRUE)

}
